/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.FixedSizeDataStore;
import com.mckoi.database.IndexSet;
import com.mckoi.debug.DebugLogger;
import com.mckoi.util.AbstractBlockIntegerList;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.ByteArrayUtil;
import com.mckoi.util.ByteBuffer;
import com.mckoi.util.Cache;
import com.mckoi.util.IntegerListBlockInterface;
import com.mckoi.util.IntegerListInterface;
import com.mckoi.util.IntegerVector;
import com.mckoi.util.UserTerminal;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class IndexStore {
    private DebugLogger debug;
    private File file;
    private int block_size;
    private FixedSizeDataStore index_store;
    private ByteBuffer index_table_list;
    private byte[] index_table_list_buf;
    private int allocation_sector;
    private int allocation_length;
    private ArrayList memory_index_set_list;
    private ArrayList index_set_garbage;
    private long unique_id;
    private Cache sector_cache;
    private byte[] flush_buffer = new byte[32];
    private long SET_ID_KEY = 0L;
    private static IndexIntegerList[] EMPTY_INTEGER_LISTS = new IndexIntegerList[0];

    public IndexStore(File file_name, DebugLogger logger) {
        this.debug = logger;
        this.file = file_name;
        this.memory_index_set_list = new ArrayList();
        this.index_set_garbage = new ArrayList();
        this.sector_cache = new Cache(47, 47, 10);
    }

    private synchronized void readIndexTableList() throws IOException {
        byte[] buf = new byte[32];
        this.index_store.readReservedBuffer(buf, 0, 32);
        this.allocation_sector = ByteArrayUtil.getInt(buf, 0);
        this.allocation_length = ByteArrayUtil.getInt(buf, 4);
        this.unique_id = ByteArrayUtil.getLong(buf, 8);
        buf = new byte[this.allocation_length];
        this.index_store.readAcross(this.allocation_sector, buf, 0, this.allocation_length);
        this.index_table_list_buf = new byte[this.allocation_length];
        this.index_table_list = new ByteBuffer(this.index_table_list_buf);
        this.index_table_list.put(buf);
    }

    private synchronized void initBlank() throws IOException {
        this.allocation_length = 0;
        byte[] buf = new byte[this.allocation_length];
        this.allocation_sector = this.index_store.writeAcross(buf, 0, buf.length);
        buf = new byte[32];
        ByteArrayUtil.setInt(this.allocation_sector, buf, 0);
        ByteArrayUtil.setInt(this.allocation_length, buf, 4);
        ByteArrayUtil.setLong(1L, buf, 8);
        this.index_store.writeReservedBuffer(buf, 0, 32);
    }

    public synchronized boolean exists() throws IOException {
        return this.file.exists();
    }

    public synchronized void create(int block_size) throws IOException {
        if (this.index_store != null && !this.index_store.isClosed()) {
            throw new Error("Index store is already open.");
        }
        if (block_size > Short.MAX_VALUE) {
            throw new Error("block_size must be less than 32768");
        }
        if (this.exists()) {
            throw new IOException("Index store file '" + this.file + "' already exists.");
        }
        this.unique_id = 1L;
        this.block_size = block_size;
        int sector_size = block_size * 4;
        this.index_store = new FixedSizeDataStore(this.file, sector_size, false, this.debug);
        this.index_store.open(false);
        this.initBlank();
    }

    public synchronized boolean open(boolean read_only) throws IOException {
        if (this.index_store != null && !this.index_store.isClosed()) {
            throw new Error("Index store is already open.");
        }
        if (this.index_store == null) {
            this.index_store = new FixedSizeDataStore(this.file, -1, false, this.debug);
        }
        boolean dirty_open = this.index_store.open(read_only);
        int sector_size = this.index_store.getSectorSize();
        if (sector_size % 4 != 0) {
            throw new Error("Assert failed, sector size must be divisible by 4");
        }
        this.block_size = sector_size / 4;
        return dirty_open;
    }

    public synchronized void init() throws IOException {
        this.readIndexTableList();
    }

    public synchronized boolean fix(UserTerminal terminal) throws IOException {
        this.index_store.fix(terminal);
        this.readIndexTableList();
        int raw_sector_count = this.index_store.rawSectorCount();
        try {
            byte[] buf = new byte[32];
            this.index_store.readReservedBuffer(buf, 0, 32);
        }
        catch (IOException e) {
            terminal.println("! Index store is irrepairable - reserved area is missing.");
            throw new IOException("Irrepairable index store.");
        }
        try {
            this.readIndexTableList();
            long used_block_count = 0L;
            long total_block_count = 0L;
            BlockIntegerList sector_list = new BlockIntegerList();
            this.index_table_list.position(0);
            while (this.index_table_list.position() < this.index_table_list.limit()) {
                byte type = this.index_table_list.getByte();
                int block_count = this.index_table_list.getInt();
                int stat_sector = this.index_table_list.getInt();
                if (stat_sector != -1) {
                    boolean b = sector_list.uniqueInsertSort(stat_sector);
                    if (!b) {
                        terminal.println("! Index store is not stable - double reference to stat_sector.");
                        return false;
                    }
                    if (stat_sector < 0 || stat_sector >= raw_sector_count || this.index_store.isSectorDeleted(stat_sector)) {
                        terminal.println("! Index store is not stable - referenced sector is deleted.");
                        return false;
                    }
                }
                for (int i = 0; i < block_count; ++i) {
                    int first_entry = this.index_table_list.getInt();
                    int last_entry = this.index_table_list.getInt();
                    int block_sector = this.index_table_list.getInt();
                    short int_count = this.index_table_list.getShort();
                    used_block_count += (long)int_count;
                    total_block_count += (long)this.block_size;
                    boolean b = sector_list.uniqueInsertSort(block_sector);
                    if (!b) {
                        terminal.println("! Index store is not stable - double reference to block sector.");
                        return false;
                    }
                    if (block_sector < 0 || block_sector >= raw_sector_count || this.index_store.isSectorDeleted(block_sector)) {
                        terminal.println("! Index store is not stable - referenced sector is deleted.");
                        return false;
                    }
                    byte[] block_contents = this.index_store.getSector(block_sector);
                    if (int_count <= 0 || ByteArrayUtil.getInt(block_contents, 0) == first_entry && ByteArrayUtil.getInt(block_contents, (int_count - 1) * 4) == last_entry) continue;
                    terminal.println("! A block of an index list does not correctly correspond to its header info.");
                    return false;
                }
            }
            terminal.println("- Index store is stable.");
            terminal.println("- Total used block count = " + used_block_count);
            terminal.println("- Total available block count = " + total_block_count);
            if (total_block_count != 0L) {
                double utilization = (float)used_block_count / (float)total_block_count * 100.0f;
                terminal.println("- Index store utilization = " + utilization + "%");
            }
            return true;
        }
        catch (IOException e) {
            terminal.println("! IO Error scanning index store: " + e.getMessage());
            return false;
        }
    }

    public synchronized boolean isReadOnly() {
        return this.index_store.isReadOnly();
    }

    public synchronized void delete() {
        this.index_store.delete();
    }

    public synchronized void copyTo(File path) throws IOException {
        this.index_store.copyTo(path);
    }

    public synchronized void close() throws IOException {
        this.index_store.close();
        this.sector_cache = null;
        this.memory_index_set_list = null;
        this.index_set_garbage = null;
    }

    public synchronized void flush() throws IOException {
        int old_sector = this.allocation_sector;
        int old_length = this.allocation_length;
        this.allocation_length = this.index_table_list_buf.length;
        this.allocation_sector = this.index_store.writeAcross(this.index_table_list_buf, 0, this.allocation_length);
        ByteArrayUtil.setInt(this.allocation_sector, this.flush_buffer, 0);
        ByteArrayUtil.setInt(this.allocation_length, this.flush_buffer, 4);
        ByteArrayUtil.setLong(this.unique_id, this.flush_buffer, 8);
        this.index_store.writeReservedBuffer(this.flush_buffer, 0, 32);
        this.index_store.deleteAcross(old_sector);
    }

    public synchronized void hardSynch() throws IOException {
        this.index_store.hardSynch();
    }

    long currentUniqueID() {
        return this.unique_id - 1L;
    }

    long nextUniqueID() {
        return this.unique_id++;
    }

    void setUniqueID(long value) {
        this.unique_id = value + 1L;
    }

    int getBlockSize() {
        return this.block_size;
    }

    public synchronized void addIndexLists(int count, byte type) {
        int add_size = count * 9;
        ByteBuffer old_buffer = this.index_table_list;
        this.index_table_list_buf = new byte[old_buffer.limit() + add_size];
        this.index_table_list = new ByteBuffer(this.index_table_list_buf);
        old_buffer.position(0);
        this.index_table_list.put(old_buffer);
        for (int i = 0; i < count; ++i) {
            this.index_table_list.putByte(type);
            this.index_table_list.putInt(0);
            this.index_table_list.putInt(-1);
        }
    }

    private synchronized void addIndexSetToList(IndexSet index_set) {
        this.memory_index_set_list.add(index_set);
    }

    private synchronized void removeIndexSetFromList(IndexSet index_set) {
        if (this.index_set_garbage == null) {
            return;
        }
        SnapshotIndexSet s_index_set = (SnapshotIndexSet)index_set;
        boolean b = this.memory_index_set_list.remove(index_set);
        if (!b) {
            throw new Error("IndexSet was not in the list!");
        }
        if (s_index_set.hasDeletedSectors()) {
            boolean deleted;
            this.index_set_garbage.add(index_set);
            long lowest_id = -1L;
            if (this.memory_index_set_list.size() > 0) {
                lowest_id = ((SnapshotIndexSet)this.memory_index_set_list.get(0)).getID();
            }
            do {
                SnapshotIndexSet set;
                boolean bl = deleted = (set = (SnapshotIndexSet)this.index_set_garbage.get(0)).getID() < lowest_id;
                if (!deleted) continue;
                IntegerVector to_delete = set.allDeletedSectors();
                int sz = to_delete.size();
                int n = 0;
                try {
                    for (n = 0; n < sz; ++n) {
                        int sector = to_delete.intAt(n);
                        this.index_store.deleteSector(sector);
                    }
                }
                catch (IOException e) {
                    this.debug.write(40, this, "Error deleting index " + n + " of list " + to_delete);
                    this.debug.writeException(e);
                    throw new Error("IO Error: " + e.getMessage());
                }
                this.index_set_garbage.remove(0);
            } while (deleted && this.index_set_garbage.size() > 0);
        }
    }

    public synchronized IndexSet getSnapshotIndexSet() {
        SnapshotIndexSet index_set = new SnapshotIndexSet(this.index_table_list_buf, this.allocation_length);
        this.addIndexSetToList(index_set);
        return index_set;
    }

    public synchronized void commitIndexSet(IndexSet index_set) {
        if (this.memory_index_set_list.get(this.memory_index_set_list.size() - 1) != index_set) {
            throw new Error("Can not commit IndexSet because it is not current.");
        }
        SnapshotIndexSet iset = (SnapshotIndexSet)index_set;
        byte[] new_buffer = iset.commit();
        this.index_table_list_buf = new_buffer;
        this.index_table_list = new ByteBuffer(this.index_table_list_buf, 0, this.index_table_list_buf.length);
    }

    public synchronized String statusString() throws IOException {
        return this.index_store.statusString();
    }

    private final class IndexIntegerList
    extends AbstractBlockIntegerList {
        private int index_num;
        private boolean disposed = false;
        private ArrayList deleted_blocks = new ArrayList();

        public IndexIntegerList(int index_num, MappedListBlock[] blocks) {
            super(blocks);
            this.index_num = index_num;
        }

        protected IntegerListBlockInterface newListBlock() {
            if (!this.disposed) {
                return new MappedListBlock(IndexStore.this.block_size);
            }
            throw new Error("Integer list has been disposed.");
        }

        protected void deleteListBlock(IntegerListBlockInterface list_block) {
            this.deleted_blocks.add(list_block);
        }

        public int getIndexNumber() {
            return this.index_num;
        }

        public MappedListBlock[] getAllBlocks() {
            return this.block_list.toArray(new MappedListBlock[this.block_list.size()]);
        }

        public MappedListBlock[] getDeletedBlocks() {
            return this.deleted_blocks.toArray(new MappedListBlock[this.deleted_blocks.size()]);
        }

        public void dispose() {
            this.disposed = true;
            this.block_list = null;
        }
    }

    private final class MappedListBlock
    extends BlockIntegerList.IntArrayListBlock {
        private int first_entry;
        private int last_entry;
        private int index_sector;
        private Object lock = new Object();
        private boolean mutable_block;

        public MappedListBlock(int first_int, int last_int, int mapped_sector, int size) {
            this.first_entry = first_int;
            this.last_entry = last_int;
            this.index_sector = mapped_sector;
            this.count = size;
            this.array = null;
        }

        public MappedListBlock(int block_size_in) {
            super(block_size_in);
            this.index_sector = -1;
        }

        public int getIndexSector() {
            return this.index_sector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int writeToStore() throws IOException {
            int block_count = IndexStore.this.block_size;
            byte[] arr = new byte[block_count * 4];
            int p = 0;
            for (int i = 0; i < block_count; ++i) {
                int v = this.array[i];
                ByteArrayUtil.setInt(v, arr, p);
                p += 4;
            }
            Object object = IndexStore.this;
            synchronized (object) {
                this.index_sector = IndexStore.this.index_store.addSector(arr, 0, arr.length);
            }
            object = IndexStore.this.sector_cache;
            synchronized (object) {
                IndexStore.this.sector_cache.put(new Integer(this.index_sector), this.array);
            }
            this.lock = null;
            return this.index_sector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getArray(boolean immutable) {
            Object object = this.lock;
            synchronized (object) {
                Object elem;
                if (this.array != null) {
                    this.prepareMutate(immutable);
                    return this.array;
                }
                Cache cache = IndexStore.this.sector_cache;
                synchronized (cache) {
                    elem = IndexStore.this.sector_cache.get(new Integer(this.index_sector));
                }
                if (elem != null) {
                    this.array = (int[])elem;
                    this.mutable_block = false;
                    this.prepareMutate(immutable);
                    return this.array;
                }
                int block_count = IndexStore.this.block_size;
                this.array = new int[block_count];
                Object object2 = IndexStore.this;
                synchronized (object2) {
                    try {
                        this.array = IndexStore.this.index_store.getSectorAsIntArray(this.index_sector, this.array);
                    }
                    catch (IOException e) {
                        IndexStore.this.debug.writeException(e);
                        throw new Error("IO Error: " + e.getMessage());
                    }
                }
                object2 = IndexStore.this.sector_cache;
                synchronized (object2) {
                    IndexStore.this.sector_cache.put(new Integer(this.index_sector), this.array);
                }
                this.mutable_block = false;
                this.prepareMutate(immutable);
                return this.array;
            }
        }

        public int getArrayLength() {
            return IndexStore.this.block_size;
        }

        private void prepareMutate(boolean immutable) {
            if (!immutable && !this.mutable_block) {
                this.array = (int[])this.array.clone();
                this.mutable_block = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int topInt() {
            if (this.count == 0) {
                throw new Error("No first int in block.");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.array == null) {
                    return this.last_entry;
                }
                return this.array[this.count - 1];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int bottomInt() {
            if (this.count == 0) {
                throw new Error("No first int in block.");
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.array == null) {
                    return this.first_entry;
                }
                return this.array[0];
            }
        }
    }

    private class SnapshotIndexSet
    implements IndexSet {
        private long set_id;
        private ByteBuffer buf;
        private int buf_length;
        private ArrayList integer_lists;
        private IntegerVector deleted_sectors;

        public SnapshotIndexSet(byte[] in_buf, int length) {
            this.set_id = IndexStore.this.SET_ID_KEY;
            ++IndexStore.this.SET_ID_KEY;
            this.buf = new ByteBuffer(in_buf);
            this.buf_length = length;
        }

        public IndexIntegerList[] getAllLists() {
            if (this.integer_lists == null) {
                return EMPTY_INTEGER_LISTS;
            }
            return this.integer_lists.toArray(new IndexIntegerList[this.integer_lists.size()]);
        }

        private ByteBuffer getByteBuffer() {
            return this.buf;
        }

        long getID() {
            return this.set_id;
        }

        boolean hasDeletedSectors() {
            return this.deleted_sectors != null && this.deleted_sectors.size() > 0;
        }

        IntegerVector allDeletedSectors() {
            return this.deleted_sectors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] commit() {
            ByteBuffer snapshot_buf;
            if (this.deleted_sectors != null) {
                throw new Error("'deleted_sectors' contains sectors to delete.");
            }
            this.deleted_sectors = new IntegerVector();
            IndexIntegerList[] lists = this.getAllLists();
            int sz = lists.length;
            for (int i = 0; i < sz; ++i) {
                lists[i].setImmutable();
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            ByteBuffer byteBuffer = snapshot_buf = this.getByteBuffer();
            synchronized (byteBuffer) {
                int buf_size = snapshot_buf.limit();
                snapshot_buf.position(0);
                try {
                    int index_num = 0;
                    while (snapshot_buf.position() < buf_size) {
                        byte list_type = snapshot_buf.getByte();
                        int blocks_count = snapshot_buf.getInt();
                        int stat_sector = snapshot_buf.getInt();
                        byte[] buf = new byte[blocks_count * 14];
                        snapshot_buf.get(buf, 0, buf.length);
                        IndexIntegerList list = null;
                        for (int i = 0; i < sz && list == null; ++i) {
                            if (lists[i].getIndexNumber() != index_num) continue;
                            list = lists[i];
                        }
                        if (list != null) {
                            MappedListBlock[] deleted_blocks = list.getDeletedBlocks();
                            for (int n = 0; n < deleted_blocks.length; ++n) {
                                MappedListBlock block = deleted_blocks[n];
                                int sector = block.getIndexSector();
                                if (sector == -1) continue;
                                this.deleted_sectors.addInt(sector);
                            }
                            MappedListBlock[] blocks = list.getAllBlocks();
                            blocks_count = blocks.length;
                            dout.writeByte(list_type);
                            dout.writeInt(blocks_count);
                            dout.writeInt(stat_sector);
                            for (int n = 0; n < blocks_count; ++n) {
                                int block_sector;
                                MappedListBlock block = blocks[n];
                                int bottom_int = 0;
                                int top_int = 0;
                                short block_size = (short)block.size();
                                if (block_size > 0) {
                                    bottom_int = block.bottomInt();
                                    top_int = block.topInt();
                                }
                                if ((block_sector = block.getIndexSector()) == -1 || block.hasChanged()) {
                                    if (block_sector != -1) {
                                        this.deleted_sectors.addInt(block_sector);
                                    }
                                    block_sector = block.writeToStore();
                                }
                                dout.writeInt(bottom_int);
                                dout.writeInt(top_int);
                                dout.writeInt(block_sector);
                                dout.writeShort(block_size);
                            }
                        } else {
                            dout.writeByte(list_type);
                            dout.writeInt(blocks_count);
                            dout.writeInt(stat_sector);
                            dout.write(buf, 0, buf.length);
                        }
                        ++index_num;
                    }
                    dout.flush();
                }
                catch (IOException e) {
                    IndexStore.this.debug.writeException(e);
                    throw new Error(e.getMessage());
                }
            }
            byte[] arr = bout.toByteArray();
            return arr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IntegerListInterface getIndex(int n) {
            int original_n = n;
            ByteBuffer byteBuffer = this.buf;
            synchronized (byteBuffer) {
                byte list_type;
                if (this.integer_lists == null) {
                    this.integer_lists = new ArrayList();
                } else {
                    for (int o = 0; o < this.integer_lists.size(); ++o) {
                        if (((IndexIntegerList)this.integer_lists.get(o)).getIndexNumber() != original_n) continue;
                        throw new Error("IntegerListInterface already created for this n.");
                    }
                }
                this.buf.position(0);
                while (n > 0) {
                    list_type = this.buf.getByte();
                    int offset = this.buf.getInt();
                    int stat_sector = this.buf.getInt();
                    this.buf.position(this.buf.position() + offset * 14);
                    --n;
                }
                list_type = this.buf.getByte();
                int list_size = this.buf.getInt();
                int list_stat_sector = this.buf.getInt();
                MappedListBlock[] list_blocks = new MappedListBlock[list_size];
                for (int i = 0; i < list_size; ++i) {
                    int first_entry = this.buf.getInt();
                    int last_entry = this.buf.getInt();
                    int block_sector = this.buf.getInt();
                    short block_size = this.buf.getShort();
                    list_blocks[i] = new MappedListBlock(first_entry, last_entry, block_sector, block_size);
                }
                IndexIntegerList ilist = new IndexIntegerList(original_n, list_blocks);
                this.integer_lists.add(ilist);
                return ilist;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            ByteBuffer byteBuffer = this.buf;
            synchronized (byteBuffer) {
                if (this.integer_lists != null) {
                    for (int i = 0; i < this.integer_lists.size(); ++i) {
                        IndexIntegerList ilist = (IndexIntegerList)this.integer_lists.get(i);
                        ilist.dispose();
                    }
                    this.integer_lists = null;
                }
            }
            this.buf = null;
            IndexStore.this.removeIndexSetFromList(this);
        }

        public void finalize() {
            if (this.buf != null) {
                IndexStore.this.debug.write(20, this, "IndexStore was not disposed!");
                IndexStore.this.removeIndexSetFromList(this);
            }
        }
    }
}

